<?php
/**
 * @package     Joomla.Site
 * @subpackage  mod_responsive_slideshow
 * @copyright   Copyright (C) 2025 Your Name. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

// No direct access
defined('_JEXEC') or die;
use Joomla\CMS\Uri\Uri;
$slideshowId = 'responsive-slideshow-' . $moduleId;
?>

<div id="<?php echo $slideshowId; ?>" class="responsive-slideshow" 
     data-transition="<?php echo $transition; ?>" 
     data-duration="<?php echo $transitionDuration; ?>">
    <div class="slideshow-container">
        <?php if (!empty($images)) : ?>
            <?php $slideCount = 0; ?>
            <?php foreach ($images as $image) : ?>
                <?php if (!empty($image->image)) : ?>
                    <div class="slide <?php echo $slideCount === 0 ? 'active' : ''; ?>">
                        <img src="<?php echo Uri::root() . $image->image; ?>" 
                             alt="<?php echo htmlspecialchars($image->alt, ENT_QUOTES, 'UTF-8'); ?>" 
                             loading="lazy">
                        <?php if (!empty($image->title)) : ?>
                            <div class="slide-title"><?php echo htmlspecialchars($image->title, ENT_QUOTES, 'UTF-8'); ?></div>
                        <?php endif; ?>
                    </div>
                    <?php $slideCount++; ?>
                <?php endif; ?>
            <?php endforeach; ?>
        <?php endif; ?>
        
        <button class="slideshow-nav prev-slide" aria-label="Previous slide">
            <span class="nav-icon">&#10094;</span>
        </button>
        <button class="slideshow-nav next-slide" aria-label="Next slide">
            <span class="nav-icon">&#10095;</span>
        </button>
    </div>
    
    <?php if ($slideCount > 1) : ?>
        <div class="slide-indicators">
            <?php for ($i = 0; $i < $slideCount; $i++) : ?>
                <button class="indicator <?php echo $i === 0 ? 'active' : ''; ?>" 
                        data-slide="<?php echo $i; ?>" 
                        aria-label="Go to slide <?php echo $i + 1; ?>"></button>
            <?php endfor; ?>
        </div>
    <?php endif; ?>
</div>