<?php
/**
 * @package     Joomla.Plugin
 * @subpackage  System.Keywords
 * @author      StArt Designs
 * @copyright   Copyright (C) 2025 Boki. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;



use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\CMS\Factory;

class PlgSystemKeywords extends CMSPlugin
{
    public function onBeforeCompileHead()
    {
        $app = Factory::getApplication();

        if ($app->isClient('administrator')) {
            return;
        }

        $keywords = trim($this->params->get('keywords', ''));

        if (!empty($keywords)) {
            $doc = Factory::getDocument();
            $doc->setMetaData('keywords', $keywords);
        }
    }
}
