<?php

/**
 * @license GNU General Public License version 2 or later; see LICENSE.txt
 */

\defined('_JEXEC') or die;

use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\CMS\Factory;
use Joomla\CMS\Form\Form;
use Joomla\CMS\Uri\Uri;

class PlgContentOgtags extends CMSPlugin
{
    protected $autoloadLanguage = true;

    public function onContentPrepare($context, &$article, &$params, $limitstart = 0)
    {
        $app = Factory::getApplication();

        if (!$app->isClient('site')) {
            return;
        }

        // Use $article->params if available, fallback to $params
        $articleParams = isset($article->params) && is_object($article->params) ? $article->params : $params;

        $ogTitle = $articleParams->get('og_title', '');
        $ogDescription = $articleParams->get('og_description', '');
        $ogImage = $articleParams->get('og_image', '');

        if (empty($ogTitle) && empty($ogDescription) && empty($ogImage)) {
            return;
        }

        $document = Factory::getDocument();

        if (!empty($ogTitle)) {
            $document->setMetaData('og:title', $ogTitle, 'property');
        }

        if (!empty($ogDescription)) {
            $document->setMetaData('og:description', $ogDescription, 'property');
        }

        if (!empty($ogImage)) {
            // Make og:image absolute if needed
            if (strpos($ogImage, 'http') !== 0) {
                $uri = Uri::root();
                $ogImage = rtrim($uri, '/') . '/' . ltrim($ogImage, '/');
            }

            $document->setMetaData('og:image', $ogImage, 'property');
        }
    }

    public function onContentPrepareForm($form, $data)
    {
        // Load OG Tags form into article editor
        if (!($form instanceof Form)) {
            return;
        }

        if ($form->getName() !== 'com_content.article') {
            return;
        }

        Form::addFormPath(__DIR__ . '/forms');
        $form->loadFile('ogtags', false);
    }
}
