<?php
defined('_JEXEC') or die;

use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\CMS\Factory;

class PlgSystemAutokeywords extends CMSPlugin
{
    protected $app;

    public function onAfterRender()
    {
        $app = Factory::getApplication();
        $input = $app->input;

        if (!$app->isClient('site') ||
            $input->getCmd('option') !== 'com_content' ||
            $input->getCmd('view') !== 'article') {
            return;
        }

        $id = $input->getInt('id');
        if (!$id) return;

        $db = Factory::getDbo();
        $query = $db->getQuery(true)
            ->select($db->quoteName(['title', 'introtext', 'fulltext', 'metakey']))
            ->from($db->quoteName('#__content'))
            ->where($db->quoteName('id') . ' = ' . (int) $id);
        $db->setQuery($query);
        $article = $db->loadObject();

        if (!$article) return;

        if (empty($article->metakey)) {
            $text = strip_tags($article->title . ' ' . $article->introtext . ' ' . $article->fulltext);
            $text = strtolower($text);
            $words = str_word_count($text, 1);

            $minLength = (int) $this->params->get('min_word_length', 4);
            $blacklist = array_map('trim', explode(',', $this->params->get('blacklist', 'article, content, page, text, write')));
            $filtered = array_filter($words, function($word) use ($minLength, $blacklist) {
                return strlen($word) >= $minLength && !in_array($word, $blacklist);
            });

            $freq = array_count_values($filtered);
            arsort($freq);
            $maxKeywords = (int) $this->params->get('max_keywords', 15);
            $keywords = array_slice(array_keys($freq), 0, $maxKeywords);
            $article->metakey = implode(', ', $keywords);

            $query = $db->getQuery(true)
                ->update($db->quoteName('#__content'))
                ->set($db->quoteName('metakey') . ' = ' . $db->quote($article->metakey))
                ->where($db->quoteName('id') . ' = ' . (int) $id);
            $db->setQuery($query);
            $db->execute();
        }

        if (!empty($article->metakey)) {
            $body = $app->getBody();
            $metaTag = '<meta name="keywords" content="' . htmlspecialchars($article->metakey, ENT_QUOTES, 'UTF-8') . '">';
            $body = preg_replace('/(<head[^>]*>)/i', '$1' . "\n    " . $metaTag, $body, 1);
            $app->setBody($body);
        }
    }
}
